# Comprehensive health audit using Shadow analyze toolkit.

## Workflow

1. **Hologram Overview**: `ReadMcpResourceTool(server: "lish", uri: "repo://current/hologram")` — See architecture baseline.
2. **Metrics Check**: `ReadMcpResourceTool(server: "lish", uri: "repo://current/metrics")` — Index health, query performance.
3. **Dead Code Detection**: `mcp_lish_shadow_analyze(mode: "dead-code", limit: 100, includeTests: false, repoPath: "...")` — Unused exports.
4. **Circular Dependencies**: `mcp_lish_shadow_analyze(mode: "circular-deps", limit: 20, repoPath: "...")` — Import cycles.
5. **Layer Integrity**: `mcp_lish_shadow_recon(mode: "topography", repoPath: "...")` — Check separation of concerns.
6. **Dependency Graph**: `ReadMcpResourceTool(server: "lish", uri: "repo://current/dependency-graph")` — Full import map.
7. **Log Findings**: `mcp_lish_shadow_ops(action: "log", missionId: ..., type: "discovery", content: "...", repoPath: "...")`.
8. **Create Cleanup Mission** (optional): `mcp_lish_shadow_ops(action: "plan", name: "Codebase Cleanup", templateId: "refactoring", templateVars: {"target": "..."}, repoPath: "...")`.

## Precise Tooling (Lish Shadow MCP)

| Audit Target            | Tool Call                                                                       |
| :---------------------- | :------------------------------------------------------------------------------ |
| **Architecture**  | `ReadMcpResourceTool(server: "lish", uri: "repo://current/hologram")`         |
| **Metrics**       | `ReadMcpResourceTool(server: "lish", uri: "repo://current/metrics")`          |
| **Dead Code**     | `shadow_analyze(mode: "dead-code", limit: 100)`                               |
| **Circular Deps** | `shadow_analyze(mode: "circular-deps")`                                       |
| **Layers**        | `shadow_recon(mode: "topography")`                                            |
| **Dep Graph**     | `ReadMcpResourceTool(server: "lish", uri: "repo://current/dependency-graph")` |

## Health Criteria

- **Critical Issues**: Circular deps in core logic, >50 dead exports
- **Warning Signs**: Layer violations (Test → Logic), >20 dead exports
- **Good Health**: Clean layers, <10 dead exports, no circular deps
