# Retrieve narrative archive from Git-native memory.

## Workflow

1. **Recent History**: `mcp_lish_shadow_ops(action: "chronicle", limit: 10, format: "markdown", repoPath: "...")` — Last 10 entries.
2. **Time-Filtered**:
   - `mcp_lish_shadow_ops(action: "chronicle", since: 1769700000, limit: 20, repoPath: "...")` — Unix timestamp
   - `mcp_lish_shadow_ops(action: "chronicle", until: 1769800000, limit: 20, repoPath: "...")`
3. **Structured Data**: `mcp_lish_shadow_ops(action: "chronicle", format: "json", limit: 50, repoPath: "...")` — For processing.
4. **Paginated**: `mcp_lish_shadow_ops(action: "chronicle", limit: 10, offset: 10, repoPath: "...")` — Second page.

## Precise Tooling (Lish Shadow MCP)

| Chronicle Query             | Tool Call                                                          |
| :-------------------------- | :----------------------------------------------------------------- |
| **Recent (Markdown)** | `shadow_ops(action: "chronicle", limit: 10, format: "markdown")` |
| **Time Range**        | `shadow_ops(action: "chronicle", since: <unix>, until: <unix>)`  |
| **JSON Data**         | `shadow_ops(action: "chronicle", format: "json", limit: 50)`     |
| **Pagination**        | `shadow_ops(action: "chronicle", limit: 10, offset: 10)`         |

## Output Formats

- **`format: "markdown"`** (default): Human-readable narrative feed with missions grouped as Strategic Initiatives and Standalone Episodes
- **`format: "json"`**: Structured data for programmatic analysis (includes missionId, steps, timestamps, ADRs)

## Use Cases

- **Onboarding**: Read last 10 entries to catch up
- **Release Notes**: Get completed missions since last release
- **ADR Review**: Extract all architectural decisions
- **Progress Reports**: Show what's been done this week

**Note:** Chronicle reads from Git Notes, so it's persistent across branches and clones.
