# Get briefing (+ optional trace), pick **one mission** from **next_work_candidates**, then work that mission to completion — all remaining steps in one run. Update and log as you go. No status reports; when you're done with that mission, it's done.

---

## 1. Context

- `mcp_lish_shadow_ops(action: "briefing", scope: "project", includeGroupedByParent: true, repoPath: "...")` → **next_work_candidates**, parents_summary.
- `mcp_lish_shadow_sync(action: "trace", repoPath: "...")` only if you care about external changes. Otherwise skip.

## 2. Pick one mission

- Choose one mission from **next_work_candidates** (no parent-only — they're umbrellas). Prefer in-progress, then planned. That mission is your scope for this run.

## 3. Work the whole mission

- For that mission, run through **all remaining steps** (not just one):
  - **Surgical Discovery:** `mcp_lish_shadow_analyze(mode: "flow", symbolName: "...", filePath: "...", repoPath: "...")`.
  - **Execute Step**: Set in-progress → implement → `mcp_lish_shadow_ops(action: "update", missionId: ..., stepId: "...", status: "completed", contextPivot: "...", repoPath: "...")`.
  - **Atomic Logging:** At least once per step. `mcp_lish_shadow_ops(action: "log", missionId: ..., type: "decision", content: "...", symbolName: "...", repoPath: "...")`.
- When all steps are done: `mcp_lish_shadow_ops(action: "update", missionId: ..., status: "completed", repoPath: "...")`.
- **Final Synthesis**: `mcp_lish_shadow_ops(action: "synthesize", missionId: ..., repoPath: "...")`.

## Precise Tooling (Lish Shadow MCP)

| Action                | Tool Call Example                                                                 |
| :-------------------- | :-------------------------------------------------------------------------------- |
| **Briefing**    | `shadow_ops(action: "briefing", scope: "project")`                              |
| **Flow Trace**  | `shadow_analyze(mode: "flow", symbolName: "handleRequest")`                     |
| **Step Update** | `shadow_ops(action: "update", missionId: 4, stepId: "s2", status: "completed")` |
| **Intent Log**  | `shadow_ops(action: "log", missionId: 4, type: "fix", content: "...")`          |
| **Seal**        | `shadow_ops(action: "synthesize", missionId: 4)`                                |

*Note: Always use `symbolName` in `shadow_ops(log)` to create Liquid Anchors.*

## 4. Don't

- Don't do one step and stop — /continue is "finish a mission," not "do one step."
- Don't long status reports. Don't ask "what should I work on?" unless a real tie. Don't auto-commit.

---

**Tools:** shadow_ops (briefing, update, **log**), shadow_sync (trace). For discovery: shadow_search, shadow_recon, shadow_analyze. Server: **user-lish**.
