# Mission Strategy & Setup

Define the objective, strategy, and success criteria for a new mission. This workflow is for **Strategic Alignment and Planning**.

> **IMPORTANT**: This workflow stops at the "Ready to Execute" state. For implementation and automated execution, use **/continue**.

## Workflow

1. **Contextual Awareness**: `mcp_lish_shadow_ops(action: "briefing", scope: "project")` — Identify the current state and "Next Work" candidates.
2. **Narrative Anchor**: `mcp_lish_shadow_ops(action: "chronicle", limit: 5)` — Understand the historical decisions and ADRs that impact this goal.
3. **Topological Recon**: `mcp_lish_shadow_recon(mode: "topography")` — Align the goal with the target architectural layers (Entry/Logic/Data).
4. **Strategic Plan**: `mcp_lish_shadow_ops(action: "plan", name: "...", goal: "...", outcomeContract: "...")`.
   * **Strategy DAG**: Define logical steps and verification rules.
   * **Initiative vs Mission**: Decide if this is a parent (Initiative) or a leaf (Mission).
5. **Alignment**: Present the plan to the user. Do not begin execution until the user approves the strategy.

## Precise Tooling (Lish Shadow MCP)

| Setup Action                | Precise Tool Call                    | Usage                                  |
| :-------------------------- | :----------------------------------- | :------------------------------------- |
| **Establish Plan**    | `shadow_ops(action: "plan")`       | Create the mission and strategy.       |
| **Architectural Map** | `shadow_recon(mode: "topography")` | Contextualize the target layers.       |
| **Briefing**          | `shadow_ops(action: "briefing")`   | Check for existing mission collisions. |
| **Graph View**        | `shadow_ops(action: "graph")`      | Visualize the initiative's hierarchy.  |

*Note: Pure Missions are about setting the destination and the route. Ensure the `outcomeContract` is binary and verifiable.*

## Intent Logging (Strategic Quality)

Capture the "Why" and "How" during the planning phase to ensure the final ADR has architectural depth.

* **Decision Logs**: Capture why a specific strategy or library was chosen.
* **Discovery Logs**: Record insights found during initial reconnaissance.

**Hand-off**: Once the mission is planned and logged, the setup phase is over. Execute via `/continue`.