# Repository Onboarding

Initialize and analyze a new repository for deep intelligence.

## Workflow

1.  **Semantic Init**: `mcp_lish_shadow_recon(mode: "init", repoPath: "...")` — **Only run once** per repo to build the baseline. Auto-populates the hologram.
2.  **Read Hologram**: `ReadMcpResourceTool(server: "lish", uri: "repo://current/hologram")` — Get instant architectural context (~1300 tokens: topography + gravity zones).
3.  **Unified Sync**: `mcp_lish_shadow_sync(action: "trace", repoPath: "...")` — **The One-Stop Shop**. Performs indexing + ghost analysis + mission re-hydration.
4.  **Active Briefing**: `mcp_lish_shadow_ops(action: "briefing", scope: "project", includeGroupedByParent: true, repoPath: "...")` — Resumes the shared backlog.
5.  **Architectural Deep Dive** (optional):
    - `mcp_lish_shadow_recon(mode: "topography", repoPath: "...")` — View layers (Entry/Logic/Data/Utility/Test).
    - `mcp_lish_shadow_ops(action: "chronicle", limit: 5, repoPath: "...")` — Narrative feed.
6.  **Hooks Activation**: `mcp_lish_shadow_env(action: "install", enableAutoRefresh: true, enableSymbolHealing: true, repoPath: "...")`.
7.  **Establish Mission**: `mcp_lish_shadow_ops(action: "plan", name: "...", goal: "...", repoPath: "...")`.

## Precise Tooling (Lish Shadow MCP)

| Action | Tool Call Example |
| :--- | :--- |
| **Index** | `shadow_recon(mode: "init")` |
| **Hologram** | `ReadMcpResourceTool(server: "lish", uri: "repo://current/hologram")` |
| **Metrics** | `ReadMcpResourceTool(server: "lish", uri: "repo://current/metrics")` |
| **Layers** | `shadow_recon(mode: "topography")` |
| **History** | `shadow_ops(action: "chronicle", limit: 10)` |
| **Resume** | `shadow_ops(action: "briefing", scope: "project")` |
| **Hooks** | `shadow_env(action: "install")` |

*Note: Always use absolute paths for `repoPath`. Read the hologram resource immediately after init for instant context.*