# Architectural Understanding

Find the high-signal path to understanding complex logic.

## Workflow

1. **Hologram Overview**: `ReadMcpResourceTool(server: "lish", uri: "repo://current/hologram")` — Get instant context (topography + gravity zones).
2. **Intent Retrieval (The Why)**: `mcp_lish_shadow_ops(action: "chronicle", limit: 5, repoPath: "...")` — Recent decisions and changes.
3. **Topological Placement (The Where)**:
   - `mcp_lish_shadow_recon(mode: "topography", repoPath: "...")` — Identify Entry/Logic/Data layers.
   - `mcp_lish_shadow_recon(mode: "tree", subPath: "src/services", maxDepth: 2, repoPath: "...")` — Focused tree.
4. **Relational Analysis (The Who)**:
   - `mcp_lish_shadow_analyze(mode: "impact", symbolName: "...", filePath: "...", depth: 3, repoPath: "...")` — Blast radius.
   - `mcp_lish_shadow_analyze(mode: "deps", filePath: "...", direction: "imported_by", repoPath: "...")` — Who depends on this?
   - `mcp_lish_shadow_search(mode: "concept", query: "...", includeTests: false, repoPath: "...")` — Semantic search.
5. **Mechanics (The How)**:
   - **For Logic**: `mcp_lish_shadow_analyze(mode: "flow", symbolName: "...", filePath: "...", repoPath: "...")` — Trace execution.
   - **For Objects**: `mcp_lish_shadow_inspect(mode: "file", filePath: "...", detailLevel: "signatures", repoPath: "...")` — All exports.
   - **For Symbol Deep Dive**: `mcp_lish_shadow_inspect(mode: "symbol", symbolName: "...", filePath: "...", context: "full", repoPath: "...")` — With deps.
6. **Synthesis**: `mcp_lish_shadow_ops(action: "log", missionId: ..., type: "discovery", content: "...", symbolName: "...", repoPath: "...")`.

## Precise Tooling (Lish Shadow MCP)

| Discovery Layer        | Precise Tool Call                                           |
| :--------------------- | :---------------------------------------------------------- |
| **Hologram**     | `ReadMcpResourceTool(server: "lish", uri: "repo://current/hologram")` |
| **History**      | `shadow_ops(action: "chronicle", limit: 5)`               |
| **Layers**       | `shadow_recon(mode: "topography")`                        |
| **Blast Radius** | `shadow_analyze(mode: "impact", symbolName: "...", depth: 3)` |
| **Dependents**   | `shadow_analyze(mode: "deps", direction: "imported_by")` |
| **Flow Trace**   | `shadow_analyze(mode: "flow", symbolName: "...")`         |
| **Structure**    | `shadow_inspect(mode: "file", detailLevel: "signatures")` |
| **Deep Dive**    | `shadow_inspect(mode: "symbol", context: "full")`         |

*Note: Always start with the hologram for instant architectural context. Use `context: "definition"` for token-efficient single symbol inspection.*
