# Workspace Orchestration

Manage multi-repository workspaces and cross-repo mission links using the Shadow Engine.

## Workflow

1. **List Workspaces**: `mcp_lish_shadow_workspace(action: "list", repoPaths: ["...", "..."], repoPath: "...")`.
2. **Federated Search**: `mcp_lish_shadow_workspace(action: "fuse", repoPaths: [...], repoPath: "...")`.
3. **Link Missions**: `mcp_lish_shadow_workspace(action: "link", parentRepoPath: "...", parentMissionId: 1, childRepoPath: "...", childMissionId: 2, relationship: "blocks", repoPath: "...")`.
4. **Verify Graph**: `mcp_lish_shadow_ops(action: "graph", missionId: 1, depth: 3, repoPath: "...")`.

## Precise Tooling (Lish Shadow MCP)

| Action | Precise Tool Call |
| :--- | :--- |
| **List** | `shadow_workspace(action: "list", repoPaths: [...])` |
| **Fuse** | `shadow_workspace(action: "fuse", repoPaths: [...])` |
| **Link** | `shadow_workspace(action: "link", parentMissionId: 1, ...)` |
| **Visualize** | `shadow_ops(action: "graph", missionId: 1)` |

*Note: Use `fused-search` after `fuse` to look up concepts across all repositories simultaneously.*

## Tooling Strategy

This skill relies on the **Lish Shadow Engine** (MCP). Use `mcp_lish_shadow_workspace` (fuse) early in multi-repo sessions to unlock "X-Ray" vision across boundaries.